var com;

if (!com) com = {};
if (!com.jdsi) com.jdsi = {};

com.jdsi.utils = {};

//this is the global variable
utils = com.jdsi.utils;

(function () {

    com.jdsi.utils.getJSONSync = getJSONSync;
    com.jdsi.utils.getRawStringSync = getRawStringSync;


  //this function is used to when you are making a blocking REST call
  //to a server method that returns its standard JSON object ({result: [values]})
  function getJSONSync(baseURL, method) {
    var t = setTimeout("loading", 200);
    try {
      var request = new XMLHttpRequest();
      var url = baseURL + method;
      for (var i= 2; i < arguments.length; i++) {
        url += "/" + arguments[i];
      }
      request.open("GET", encodeURI(url), false);
      if (! $("#sessionid").val() == "") {
        request.setRequestHeader("Pragma", "dssession="+$("#sessionid").val());
      }
      request.send(null);
      }
    finally {
      loadingDone(t);
    }
    if (request.status != 200) {
      throw new Error(request.statusText);
    }
    $("#sessionid").val(request.getResponseHeader('Pragma').split(',')[0].split("=")[1]);
    return jQuery.parseJSON(request.responseText);
  }


  //This is the function that you call when you are making a blocking REST call
  //to a server method that uses GetInvocationMetadata to return raw strings
  function getRawStringSync(baseURL, method) {
    var request = new XMLHttpRequest();
    var url = baseURL + method;
    for (var i= 2; i < arguments.length; i++) {
      url += "/" + arguments[i];
    }
    request.open("GET", encodeURI(url), false);
    var t = setTimeout("loading()", 200);
    if (! $("#sessionid").val() == "") {
      request.setRequestHeader("Pragma", "dssession="+$("#sessionid").val());
    }
    request.send(null);
    if (request.status != 200) {
      loadingDone(t);
      throw new Error(request.statusText);
    }
    $("#sessionid").val(request.getResponseHeader('Pragma').split(',')[0].split("=")[1]);
    loadingDone(t);
    return request.responseText;
  }

  //functions for displaying and surpressing the wait spinner
  function loading() {
    $('#loadimggif').show(); 
  }

  function loadingDone(timer) {
    clearTimeout(timer);
    $('#loadimggif').hide();
  }


})();
