unit mainformu;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, DBXJSON;

type
  TForm1 = class(TForm)
    Button1: TButton;
    echoin: TEdit;
    echoout: TLabel;
    reversein: TEdit;
    reverserawin: TEdit;
    custno: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    reverseout: TLabel;
    reverserawout: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Name: TLabel;
    City: TLabel;
    Credlimit: TLabel;
    Active: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
    function GetEchoString: String;
    function GetReverseString: String;
    function GetReverseStringRaw: String;
    function GetCustomer: String;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses RESTUtils;

const
  baseurl = 'http://localhost/DataSnapREST/DataSnapRest.dll/datasnap/rest/TServerMethods1/';

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
begin
    echoout.Caption := GetEchoString;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  reverseout.Caption := GetReverseString;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  reverserawout.Caption := GetReverseStringRaw;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  ja: TJSONArray;
  jo, jo1: TJSONObject;
  temp: string;
begin
  temp := TRESTCall.Get(baseurl + 'GetCustomer/' + custno.text);
  jo := TJSONObject.ParseJSONValue(temp) as TJSONObject;
  try
    jo1 := (jo.Get(0).JSONValue as TJSONArray).Get(0) as TJSONObject;
    if jo1.Get('Error') <> nil then
      Name.Caption := jo1.Get('Error').JsonValue.Value
    else
    begin
      Name.Caption := jo1.Get('Name').JsonValue.Value;
      City.Caption := jo1.Get('City').JsonValue.Value;
      CredLimit.Caption := jo1.Get('CreditLimit').JsonValue.Value;
      if jo1.Get('Active').JsonValue is TJSONTrue then
        Active.Caption := 'True'
      else
        Active.Caption := 'False';
    end;
  finally
    jo.Free;
  end;
end;

function TForm1.GetCustomer: String;
begin
  reverserawout.Caption := GetReverseStringRaw;
end;

function TForm1.GetEchoString: String;
var
  ja: TJSONArray;
  jo: TJSONObject;
begin
  Result := TRESTCall.Get(baseurl + 'echostring/' + echoin.text);
  jo := TJSONObject.ParseJSONValue(result) as TJSONObject;
  try
    ja := (jo.Get(0).JSONValue as TJSONArray);
    result := ja.Get(0).Value;
  finally
    jo.Free;
  end;
end;

function TForm1.GetReverseString: String;
var
  ja: TJSONArray;
  jo: TJSONObject;
begin
  Result := TRESTCall.Get(baseurl + 'reversestring/' + reversein.text);
  jo := TJSONObject.ParseJSONValue(result) as TJSONObject;
  try
    ja := (jo.Get(0).JSONValue as TJSONArray);
    result := ja.Get(0).Value;
  finally
    jo.Free;
  end;
end;

function TForm1.GetReverseStringRaw: String;
begin
  Result := TRESTCall.GetScalar(baseurl + 'reversestringraw/' + reverserawin.text);
end;

end.
