unit RESTUtils;

 ////
 ///  This unit defines a record called TRESTCall
 ///  TRESTCall makes a blocking call to a RESTful Web service
///
///   This record can only be used by one client
///
interface

uses
  Classes, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdHTTP, IdAuthentication, IdStream, IdFTP, DBXJSON;

type
  TRESTCall = record
    class function Get(const url: string): string; static;  //this one returns JSON
    class function GetScalar(const url: string): string; static; //this one returns a single string
    //This class should also implement Delete, Put, and Post methods
  end;

  // This class is use solely to expose an event handler for use by the IdHttp
  // component created in the TRESTCall.Get method
  TTemp = class
    procedure IdHTTPAuthorization(Sender: TObject;
      Authentication: TIdAuthentication; var Handled: Boolean);
  end;

implementation

{ TRESTCall }

var
  sessionid: string = '';


class function TRESTCall.Get(const url: string): string;
var
  IdHTTP: TIdHTTP;
  temp: TTemp;
  HeaderStrings: TStringList;
  StartPos, EndPos: Integer;
begin
  IdHttp := TIdHttp.Create(nil);
  try
    IdHttp.HTTPOptions := [hoInProcessAuth,hoForceEncodeParams];
    temp := TTemp.Create;
    try
      IdHttp.OnAuthorization := temp.IdHTTPAuthorization;
      if sessionid <> '' then
      begin
        HeaderStrings := TStringList.Create;
        HeaderStrings.Insert(0, 'pragma=dssession=' + sessionid);
        try
        IdHttp.Request.CustomHeaders.AddStrings(HeaderStrings);
        finally
         HeaderStrings.Free;
        end;
      end;
      Result := IdHttp.Get(url);
      StartPos := system.pos('=', IdHttp.Response.Pragma) + 1;
      EndPos := system.pos(',', IdHttp.Response.Pragma);
      sessionid := copy(IdHttp.Response.Pragma, StartPos, EndPos - StartPos);
    finally
      temp.Free;
    end;
  finally
    IdHttp.Free;
  end;
end;

class function TRESTCall.GetScalar(const url: string): string;
var
  IdHTTP: TIdHTTP;
  temp: TTemp;
  response: string;
  HeaderStrings: TStringList;
  StartPos, EndPos: Integer;
  jo: TJSONObject;
begin
  IdHttp := TIdHttp.Create(nil);
  try
    IdHttp.HTTPOptions := [hoInProcessAuth,hoForceEncodeParams];
    temp := TTemp.Create;
    try
      IdHttp.OnAuthorization := temp.IdHTTPAuthorization;
      if sessionid <> '' then
      begin
        HeaderStrings := TStringList.Create;
        HeaderStrings.Insert(0, 'pragma=dssession=' + sessionid);
        try
        IdHttp.Request.CustomHeaders.AddStrings(HeaderStrings);
        finally
         HeaderStrings.Free;
        end;
      end;
      Result := IdHttp.Get(url);
      StartPos := system.pos('=', IdHttp.Response.Pragma) + 1;
      EndPos := system.pos(',', IdHttp.Response.Pragma);
      sessionid := copy(IdHttp.Response.Pragma, StartPos, EndPos - StartPos);
    finally
      temp.Free;
    end;
  finally
    IdHttp.Free;
  end;
end;


{ TTemp }

procedure TTemp.IdHTTPAuthorization(Sender: TObject;
  Authentication: TIdAuthentication; var Handled: Boolean);
begin
  Authentication.Username := 'username';
  Authentication.Password := 'password';
  Handled := True;
end;

end.

