unit ServerMethodsUnit1;

interface

uses System.SysUtils, System.Classes, Datasnap.DSServer,
  Datasnap.DSAuth,
  DBXJSON,     // for JSON
  DBXPlatform; // for GetInvocationMetadata

type
{$METHODINFO ON}
  TServerMethods1 = class(TDataModule)
  private
    { Private declarations }
  public
    { Public declarations }
    function EchoString(Value: string): string;
    function ReverseString(Value: string): string;
    function ReverseStringRaw(Value: string): string;
    function GetCustomer(CustNo: string): TJSONObject;
  end;
{$METHODINFO OFF}

implementation

{$R *.dfm}

uses System.StrUtils;

function TServerMethods1.EchoString(Value: string): string;
begin
  Result := Value;
end;

function TServerMethods1.GetCustomer(CustNo: string): TJSONObject;
var
  Name: string;
  City: string;
  CreditLimit: Integer;
  Active: Boolean;
begin
  Result := TJSONObject.Create;
  if CustNo = '100' then
  begin
    Name := 'Frank';
    City := 'New York';
    CreditLimit := 1000;
    Active := True;
  end
  else
  if CustNo = '101' then
  begin
    Name := 'Jody';
    City := 'London';
    CreditLimit := 2000;
    Active := True;
  end
  else
  if CustNo = '102' then
  begin
    Name := 'Martin';
    City := 'Syndey';
    CreditLimit := 3000;
    Active := True;
  end
  else
  begin
    Result.AddPair('Error', 'Customer No ' +
                             CustNo + ' not found');
    exit;
  end;
  Result.AddPair('Name', Name);
  Result.AddPair('City', City);
  Result.AddPair('CreditLimit', TJSONNumber.Create(CreditLimit));
  if Active then
    Result.AddPair('Active', TJSONTrue.Create)
  else
    Result.AddPair('Active', TJSONFalse.Create);
end;

function TServerMethods1.ReverseString(Value: string): string;
begin
  Result := System.StrUtils.ReverseString(Value);
end;

function TServerMethods1.ReverseStringRaw(Value: string): string;
begin
    //Must use the DBXPlatform unit for GetInvocationMetadata
    GetInvocationMetadata().ResponseCode := 200;
    GetInvocationMetadata().ResponseContent :=
      System.StrUtils.ReverseString(Value);
end;

end.

