unit ClipView_MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TFormClipVioew = class(TForm)
    Timer1: TTimer;
    Panel1: TPanel;
    cbTrack: TCheckBox;
    memoTrack: TMemo;
    lbFormats: TListBox;
    lblClipNo: TLabel;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbTrackClick(Sender: TObject);
  private
    ClipList: TStringList;
    ClipSeqNo: Integer;

    FTrackClip: Boolean;
    procedure SetTrackClip(const Value: Boolean);
  public
    property TrackClip: Boolean read FTrackClip write SetTrackClip;

    function ClipFormatDescr (clpFormat: Integer): string;
  end;

var
  FormClipVioew: TFormClipVioew;

implementation

uses
  ClipBrd;

{$R *.dfm}

procedure TFormClipVioew.cbTrackClick(Sender: TObject);
begin
  TrackClip := cbTrack.Checked;
end;

function TFormClipVioew.ClipFormatDescr(clpFormat: Integer): string;
begin
  case clpFormat of
    CF_TEXT: Result := 'CF_TEXT';
    CF_BITMAP: Result := 'CF_BITMAP';
    CF_METAFILEPICT: Result := 'CF_METAFILEPICT';
    CF_SYLK: Result := 'CF_SYLK';
    CF_DIF: Result := 'CF_DIF';
    CF_TIFF: Result := 'CF_TIFF';
    CF_OEMTEXT: Result := 'CF_OEMTEXT';
    CF_DIB: Result := 'CF_DIB';
    CF_PALETTE: Result := 'CF_PALETTE';
    CF_PENDATA: Result := 'CF_PENDATA';
    CF_RIFF: Result := 'CF_RIFF';
    CF_WAVE: Result := 'CF_WAVE';
    CF_UNICODETEXT: Result := 'CF_UNICODETEXT';
    CF_ENHMETAFILE: Result := 'CF_ENHMETAFILE';
    CF_HDROP: Result := 'CF_HDROP';
    CF_LOCALE : Result := 'CF_LOCALE ';
    CF_DIBV5: Result := 'CF_DIBV5';

    CF_OWNERDISPLAY: Result := 'CF_OWNERDISPLAY';
    CF_DSPTEXT: Result := 'CF_DSPTEXT';
    CF_DSPBITMAP: Result := 'CF_DSPBITMAP';
    CF_DSPMETAFILEPICT: Result := 'CF_DSPMETAFILEPICT';
    CF_DSPENHMETAFILE: Result := 'CF_DSPENHMETAFILE';

    CF_PRIVATEFIRST..CF_PRIVATELAST: Result :=
      'CF_PRIVATE: ' + IntToStr (clpFormat);
  else
    Result := 'Unknown format';
  end;

end;

procedure TFormClipVioew.FormCreate(Sender: TObject);
begin
  //
end;

procedure TFormClipVioew.FormDestroy(Sender: TObject);
begin
  ClipList.Free;
end;

procedure TFormClipVioew.SetTrackClip(const Value: Boolean);
begin
  FTrackClip := Value;
end;

procedure TFormClipVioew.Timer1Timer(Sender: TObject);
var
  ClipText: string;
  I: Integer;
  NewSeqNo: Integer;
begin
  NewSeqNo := GetClipboardSequenceNumber;
  if ClipSeqNo = NewSeqNo then
    Exit; // same content as before

  // new content
  ClipSeqNo := NewSeqNo;
  lblClipNo.Caption := IntToStr (ClipSeqNo);

  // refresh available formats
  lbFormats.Clear;
  for I := 0 to Clipboard.FormatCount - 1 do
    lbFormats.Items.Add (ClipFormatDescr (Clipboard.Formats[I]));

  if TrackClip then
  begin
    // lazy-initialize string list
    if not Assigned (ClipList) then
      ClipList := TStringList.Create;
    if Clipboard.HasFormat (CF_TEXT) then
    begin
      ClipText := Clipboard.AsText;
      if ClipList.IndexOf (ClipText) < 0 then
        ClipList.Add (ClipText);
      // limit content to 500 lines (deleting 50 at a time)
      if ClipList.Count > 500 then
        for i := 1 to 50 do
          ClipList.Delete(0);
      // copy to the memo
      memoTrack.Lines.Assign (ClipList);
    end;
  end;
end;

end.
